function varargout=cs2(varargin)
%  Version 1.1 - October 24, 2003
% (c) D.Chang, O.de Weck, MIT Engineering Systems Division
%
zzz=1;
    fprintf('============================================================ \n')
    fprintf('=  Communications Satellite Constellation Simulator (CS2)  = \n')
    fprintf('=           Engineering Systems Learning Center            = \n')
    fprintf('=    (c)2003 Massachusetts Institute of Technology         = \n')
    fprintf('======================  Version 1.1 ======================== \n')
    fprintf('\n')
    
warning off 
while zzz~=0
    % obtain input file
    infname=input('Enter input filename [default: iridium_in.txt]: ','s'); % user prompt for input file name
    fprintf('\n')
    if isempty(infname)
        infname='iridium_in.txt'; % default filename contains Iridium benchmark data
    end
    
    % process inputs and do error checking on input file
    fid=fopen(infname,'r');
    while feof(fid) == 0
    tline = fgetl(fid);
      % assign input variables
      % design vector x
      if findstr(tline,'name=')
          ind=findstr(tline,'name=');
          x.name=tline(ind+6:length(tline)-1);
      elseif findstr(tline,'x.C=')
            ind=findstr(tline,'x.C=');
            x.C=str2double(tline(ind+4:length(tline)));
      elseif findstr(tline,'x.h=')
            ind=findstr(tline,'x.h=');
            x.h=str2double(tline(ind+4:length(tline)));
      elseif findstr(tline,'x.elev=')
            ind=findstr(tline,'x.elev=');
            x.elev=str2double(tline(ind+7:length(tline)));
      elseif findstr(tline,'x.diversity=')
            ind=findstr(tline,'x.diversity=');
            x.diversity=str2double(tline(ind+12:length(tline)));
      elseif findstr(tline,'x.Pt=')
            ind=findstr(tline,'x.Pt=');
            x.Pt=str2double(tline(ind+5:length(tline)));
      elseif findstr(tline,'x.GT_dB=')
            ind=findstr(tline,'x.GT_dB=');
            x.GT_dB=str2double(tline(ind+8:length(tline)));
      elseif findstr(tline,'x.ISL=')
            ind=findstr(tline,'x.ISL=');
            x.ISL=str2double(tline(ind+6:length(tline)));
      elseif findstr(tline,'x.MAS=')
            ind=findstr(tline,'x.MAS=');
            x.MAS=str2double(tline(ind+6:length(tline)));
      elseif findstr(tline,'x.Tsat=')
            ind=findstr(tline,'x.Tsat=');
            x.Tsat=str2double(tline(ind+7:length(tline)));
      %constants vector c
      elseif findstr(tline,'c.AKM=')
            ind=findstr(tline,'c.AKM=');
            c.AKM=str2double(tline(ind+6:length(tline)));
      elseif findstr(tline,'c.AKMIsp=')
            ind=findstr(tline,'c.AKMIsp=');
            c.AKMIsp=str2double(tline(ind+9:length(tline)));
      elseif findstr(tline,'c.StationIsp=')
            ind=findstr(tline,'c.StationIsp');
            c.StationIsp=str2double(tline(ind+13:length(tline)));
      elseif findstr(tline,'c.MS=')
            ind=findstr(tline,'c.MS');
            c.MS=tline(ind+6:length(tline)-1);
      elseif findstr(tline,'c.ROF=')
            ind=findstr(tline,'c.ROF');
            c.ROF=str2double(tline(ind+6:length(tline)));
      elseif findstr(tline,'c.ClusterSize=')
            ind=findstr(tline,'c.ClusterSize');
            c.ClusterSize=str2double(tline(ind+14:length(tline)));
      elseif findstr(tline,'c.NUIF=')
            ind=findstr(tline,'c.NUIF');
            c.NUIF=str2double(tline(ind+7:length(tline)));
      elseif findstr(tline,'c.Rc=')
            ind=findstr(tline,'c.Rc');
            c.Rc=tline(ind+6:length(tline));
      elseif findstr(tline,'c.K=')
            ind=findstr(tline,'c.K');
            c.K=str2double(tline(ind+4:length(tline)));
      elseif findstr(tline,'c.Risl=')
            ind=findstr(tline,'c.Risl');
            c.Risl=str2double(tline(ind+7:length(tline)));
      elseif findstr(tline,'c.Ge_dB=')
            ind=findstr(tline,'c.Ge_dB');
            c.Ge_dB=str2double(tline(ind+8:length(tline)));
      elseif findstr(tline,'c.Pe=')
            ind=findstr(tline,'c.Pe');
            c.Pe=str2double(tline(ind+5:length(tline)));
      elseif findstr(tline,'c.DR=')
            ind=findstr(tline,'c.DR');
            c.DR=str2double(tline(ind+5:length(tline)));
      elseif findstr(tline,'c.IDT=')
            ind=findstr(tline,'c.IDT');
            c.IDT=str2double(tline(ind+6:length(tline)));
      elseif findstr(tline,'c.nogoprocreft=')
            ind=findstr(tline,'c.nogoprocreft');
            c.nogoprocreft=str2double(tline(ind+15:length(tline)));
      %requirements vector r
      elseif findstr(tline,'r.BER=')
            ind=findstr(tline,'r.BER');
            r.BER=str2double(tline(ind+6:length(tline)));
      elseif findstr(tline,'r.R=')
            ind=findstr(tline,'r.R');
            r.R=str2double(tline(ind+4:length(tline)));
      elseif findstr(tline,'r.margin_dB=')
            ind=findstr(tline,'r.margin_dB');
            r.margin_dB=str2double(tline(ind+12:length(tline)));
      % policy vector p
      elseif findstr(tline,'p.Fms_uplink_lb=')
            ind=findstr(tline,'p.Fms_uplink_lb');
            p.Fms_uplink_lb=str2double(tline(ind+16:length(tline)));
      elseif findstr(tline,'p.Fms_uplink_ub=')
            ind=findstr(tline,'p.Fms_uplink_ub');
            p.Fms_uplink_ub=str2double(tline(ind+16:length(tline)));
      elseif findstr(tline,'p.Fms_downlink_lb=')
            ind=findstr(tline,'p.Fms_downlink_lb');
            p.Fms_downlink_lb=str2double(tline(ind+18:length(tline)));
       elseif findstr(tline,'p.Fms_downlink_ub=')
            ind=findstr(tline,'p.Fms_downlink_ub');
            p.Fms_downlink_ub=str2double(tline(ind+18:length(tline)));
       elseif findstr(tline,'p.launchprohibit=')
            ind=findstr(tline,'p.launchprohibit');
            p.launchprohibit=tline(ind+17:length(tline));
       elseif findstr(tline,'p.nogateways=')
            ind=findstr(tline,'p.nogateways');
            p.nogateways=tline(ind+13:length(tline)); 
        end
    end
    status=fclose(fid);
    
    % define necessary parameters
    xunits.C='[1=polar,2=walker]';
    xunits.h='[km]';
    xunits.elev='[deg]';
    xunits.diversity='[-]';
    xunits.Pt='[W]';
    xunits.GT_dB='[dBi]';
    xunits.ISL='[1=yes,0=no]';
    xunits.MAS='[1=MF-TDMA,2=MF-CDMA]';
    xunits.Tsat='[years]';
    
    cunits.AKM='[-]';
    cunits.AKMIsp='[sec]';
    cunits.StationIsp='[sec]';
    cunits.MS='[modulation]';
    cunits.ROF='[-]';
    cunits.ClusterSize='[-]';
    cunits.NUIF='[-]';
    cunits.Rc='[-]';
    cunits.K='[-]';
    cunits.Risl='[Mbps]';
    cunits.Ge_dB='[dBi]';
    cunits.Pe='[W]';
    cunits.DR='[%]';
    cunits.IDT='[years]';
    cunits.nogoprocreft='[-]';

    runits.BER='[-]';
    runits.R='[kbps]';
    runits.margin_dB='[dB]';
    
    punits.Fms_uplink_lb='[MHz]';
    punits.Fms_uplink_ub='[MHz]';
    punits.Fms_downlink_lb='[MHz]';
    punits.Fms_downlink_ub='[MHz]';
    punits.launchprohibit='[ISOcountrycode]';
    punits.nogateways='[ISOcountrycode]';
    
%%%%%
% Selections for technology
    
    % set up technology selection for the Technology Infusion Interface
TIIoption=[0 0 0 0];
option=100;
fprintf(' \n')
fprintf('Available technologies: \n')
fprintf(' 1. Optical Inter-Satellite Link \n')
fprintf(' 2. Satellite Asynchronous Transfer Mode \n')
fprintf(' 3. Large Deployable Reflector \n')
fprintf(' 4. Digital/Analog Beam Forming \n')
fprintf(' ========================================== \n')
option=input('Select technology indices [default=0]: ');
if ~isempty(option)&(option>0)&(option<5)    
        TIIoption(option) = 1;
end;

   %capture policy actions
fprintf(' \n')
PIIoption=input('Set 1 if foreign launch vehicle prohibited [default=0]: ');
if isempty(PIIoption)  
        PIIoption = 0;
end;
fprintf(' \n')

%%%% program options
    
    var=input('Display diagnostic messages (1=yes [default], 0=no): ');
    if isempty(var)
        var=1;
    elseif (var~=0)&(var~=1)
        yyy=0;
        while yyy<4
             fprintf('Wrong value entered ... try again! \n')
              var=input('Display diagnostic messages during analysis (1=yes, 0=no): ');
             if (var==0)|(var==1)
                 yyy=4;
             elseif yyy==3
                 fprintf('Maximum number of attempts exceeded ... EXITING')
                 exit
             else
                 yyy=yyy+1;
             end
         end
    end
    diagnostics=var;
    fprintf('\n')
    
    var=input('Display graphical output from analysis (1=yes, 0=no[default]): ');
    if isempty(var)
        var=0;
    elseif (var~=0)&(var~=1)
        yyy=0;
        while yyy<4
             fprintf('Wrong value entered ... try again! \n')
              var=input('Display graphical output from analysis (1=yes, 0=no): ');
             if (var==0)|(var==1)
                 yyy=4;
             elseif yyy==3
                 fprintf('Maximum number of attempts exceeded ... EXITING')
                 exit
             else
                 yyy=yyy+1;
             end
         end
    end
    plotflag=var;
    fprintf('\n')
    
    
    % perform computations
    starttime=cputime;
    % call scu2003 - main processing 
    [x,xunits,J,Junits,B,Bunits,r,runits]=cs2main(x,c,r,p,xunits,cunits,runits,punits,TIIoption,PIIoption,diagnostics,plotflag);
    
    endtime=cputime; totaltime=endtime-starttime;
    
    
    if diagnostics==1
        fprintf('\n')
        fprintf('The analysis took  %6.2f seconds \n', totaltime); %CPU time consumed
        fprintf('\n')
    end
        
    % graphical output on screen and to file
    if plotflag==1
    hfig=figure;
    bar([endtime]')
    title([infname(1:length(infname)-7) ': sum'])
    drawnow
    figfile=[infname(1:length(infname)-7) '_fig1'];
    saveas(hfig, figfile, 'jpg')
    fprintf('Ignore any get_param warning messages displayed above \n')
    fprintf('\n')
    fprintf(['The graphical results have been saved in ' infname(1:length(infname)-7) '_fig.jpg \n']); %graphical results file
    fprintf('\n')
    end
   
    
    % save numerical results in output file
    outfname=[infname(1:length(infname)-7) '_out.txt'];
    fid=fopen(outfname,'wt');
    fprintf(fid,['output file: ' x.name '\n']);
    fprintf(fid,'date = %s \n', date);
    time=clock; time=num2str(time(4:5));
    fprintf(fid,'time = %s \n', time);
    fprintf(fid,'The analysis took  %4.2f seconds \n', totaltime); %CPU time consumed
    fprintf(fid,'============================================================== \n');
    fprintf(fid,'=                          Design Vector x                   = \n');
    fprintf(fid,'============================================================== \n');
    fprintf(fid,'x.C          Constellation : %g \t\t %s \n',x.C,xunits.C);
    fprintf(fid,'x.h          Altitude      : %g \t %s \n',x.h,xunits.h);
    fprintf(fid,'x.elev       Elevation     : %g \t %s \n',x.elev,xunits.elev);
    fprintf(fid,'x.diversity  Diversity     : %g \t\t %s \n',x.diversity,xunits.diversity);
    fprintf(fid,'x.Pt         Xmit Power    : %g \t %s \n',x.Pt,xunits.Pt);
    fprintf(fid,'x.GT_dB      Xmit Gain     : %g \t %s \n',x.GT_dB,xunits.GT_dB);
    fprintf(fid,'x.ISL        InterSat Link : %g \t\t %s \n',x.ISL,xunits.ISL);
    fprintf(fid,'x.MAS        Multi Access  : %g \t\t %s \n',x.MAS,xunits.MAS);
    fprintf(fid,'x.Tsat       Sat Lifetime  : %g \t\t %s \n',x.Tsat,xunits.Tsat);
    fprintf(fid,'============================================================== \n');
    fprintf(fid,'=                       Objective Vector J                   = \n');
    fprintf(fid,'============================================================== \n');
    fprintf(fid,'J.totalcap        Capacity : %g \t %s \n',J.totalcap,Junits.totalcap);
    fprintf(fid,'J.lifecyclecost   LCC      : %g \t %s \n',J.lifecyclecost,Junits.lifecyclecost);
    fprintf(fid,'J.subscriberPerYear  Users : %g \t %s \n',J.subscriberPerYear,Junits.subscriberPerYear);
    fprintf(fid,'J.totalAirTime  Total Time : %5.2e \t %s \n',J.totalAirTime,Junits.totalAirTime);
    fprintf(fid,'J.totalDataFlow  Data Flow : %5.2e \t %s \n',J.totalDataFlow,Junits.totalDataFlow);
    fprintf(fid,'J.costPerFunction    CPF   : %g \t %s \n',J.costPerFunction,Junits.costPerFunction);
    fprintf(fid,'============================================================== \n');
    status=fclose(fid);
    
    if diagnostics==1
    fprintf('============================================================== \n');
    fprintf('=                          Design Vector x                   = \n');
    fprintf('============================================================== \n');
    fprintf('x.C          Constellation : %g \t\t %s \n',x.C,xunits.C);
    fprintf('x.h          Altitude      : %g \t %s \n',x.h,xunits.h);
    fprintf('x.elev       Elevation     : %g \t %s \n',x.elev,xunits.elev);
    fprintf('x.diversity  Diversity     : %g \t\t %s \n',x.diversity,xunits.diversity);
    fprintf('x.Pt         Xmit Power    : %g \t %s \n',x.Pt,xunits.Pt);
    fprintf('x.GT_dB      Xmit Gain     : %g \t %s \n',x.GT_dB,xunits.GT_dB);
    fprintf('x.ISL        InterSat Link : %g \t\t %s \n',x.ISL,xunits.ISL);
    fprintf('x.MAS        Multi Access  : %g \t\t %s \n',x.MAS,xunits.MAS);
    fprintf('x.Tsat       Sat Lifetime  : %g \t\t %s \n',x.Tsat,xunits.Tsat);
    fprintf('============================================================== \n');
    fprintf('=                       Objective Vector J                   = \n');
    fprintf('============================================================== \n');
    fprintf('J.totalcap        Capacity : %g \t %s \n',J.totalcap,Junits.totalcap);
    fprintf('J.lifecyclecost   LCC      : %g \t %s \n',J.lifecyclecost,Junits.lifecyclecost);
    fprintf('J.subscriberPerYear  Users : %g \t %s \n',J.subscriberPerYear,Junits.subscriberPerYear);
    fprintf('J.totalAirTime  Total Time : %5.2e \t %s \n',J.totalAirTime,Junits.totalAirTime);
    fprintf('J.totalDataFlow  Data Flow : %5.2e \t %s \n',J.totalDataFlow,Junits.totalDataFlow);
    fprintf('J.costPerFunction    CPF   : %g \t %s \n',J.costPerFunction,Junits.costPerFunction);
    fprintf('============================================================== \n');
    fprintf(['The numerical results have been saved in ' outfname ' \n']); %numerical results file
    fprintf('\n')
    end
    
    % prompt for another analysis
   
    var=input('Do you want to perform a new analysis? (yes=1, no=0 [default]): ');
    if isempty(var)
        var=0;
    elseif (var~=0)&(var~=1)
        yyy=0;
        while yyy<4
             fprintf('Wrong value entered ... try again! \n')
              var=input('Do you want to perform a new analysis? (yes=1, no=0): ');
             if (var==0)|(var==1)
                 yyy=4;
             elseif yyy==3
                 fprintf('Maximum number of attempts exceeded ... EXITING')
                 exit
             else
                 yyy=yyy+1;
             end
         end
    end
    zzz=var;
    
    fprintf('\n')
    if zzz==0
        fprintf('============================================================ \n')
        fprintf('=             Successfully Completed Analysis              = \n')
        fprintf('============================================================ \n')
        return
        %exit
    end
end

